﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using HoundSharp;

namespace WindowsFormsApplication1
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            double myStartFrequency = 248.91e6;
            double myStopFrequency = 249.09e6;
            double myCtrFreq = 249.000100e6;
            int myFFTSize = 512; //50 KHz RBW
            int returnCount = 0;
            int i;

            // To do: Delete this line or modify this to point to wherever you put the HOUND2PIPE process executable.  Default is (working directory).
          //  SA44B_Device.myPipeExe = "c:\\Justin\\HOUND2PIPE.exe";

            textBox1.Text = "Please wait 10 seconds for initialization\r\n";

            SA44B_Device.SHAPI_Initialize();
            SA44B_Device.SHAPI_Configure(10.0, 1, 1, 1, 0, 0);

            int[] Iarray = new int[1024];
            int[] Qarray = new int[1024];

            SA44B_Device.SHAPI_GetIQDataPacket(Iarray, Qarray, ref myCtrFreq, 1024);
  
            String myValStr;
   
            textBox1.Text += String.Format("SHAPI_GetIQDataPacket returned ctr freq {0}\r\n", myCtrFreq);

            int count = SA44B_Device.SHAPI_GetSlowSweepCount(myStartFrequency, myStopFrequency, myFFTSize);
            double[] myTrace = new double[count+4];
            SA44B_Device.SHAPI_GetSlowSweep(myTrace, myStartFrequency, myStopFrequency, ref returnCount, myFFTSize, 2, 0);

            textBox1.Text += String.Format("SHAPI_GetSlowSweep returned {0} points\r\n", returnCount);


            count = SA44B_Device.SHAPI_GetFastSweepCount(248.0e6, 250.0e6, 16);
            double[] myTrace2 = new double[count];
            SA44B_Device.SHAPI_GetFastSweep(myTrace2, 248.0e6, 250.0e6, ref returnCount, 16, 0);
            textBox1.Text += String.Format("SHAPI_GetFastSweep returned {0} points:\r\n", returnCount);

            for (i = 0; i < count; i++)
            {
                myValStr = String.Format("{0} ",myTrace2[i]);
                textBox1.Text += myValStr;
            }

            textBox1.Text += "\r\n\r\nRunning Measurement Receiver...\r\n";

            SA44B_Device.SHAPI_Configure(10.0, 1, 1, 8, 1, 0);
            MEAS_RCVR_STRUCT myMeasRcvr = new MEAS_RCVR_STRUCT();
            myMeasRcvr.RFFrequency = 249.0e6;
            myMeasRcvr.UseBPF = 0;
            myMeasRcvr.UseLPF = 1;
            myMeasRcvr.AudioLPFreq = 2.0e3;

            SA44B_Device.SHAPI_RunMeasurementReceiver(ref myMeasRcvr);

            textBox1.Text += String.Format("FM audio Freq {0} \r\n ", myMeasRcvr.FMAudioFreq);
            textBox1.Text += String.Format("RFAmplitude {0}  \r\n", myMeasRcvr.RFAmplitude);
            textBox1.Text += String.Format("FMPeakPlus {0}  \r\n", myMeasRcvr.FMPeakPlus);
            textBox1.Text += String.Format("FMPeakMinus {0}  \r\n", myMeasRcvr.FMPeakMinus);
            textBox1.Text += String.Format("FMRMS {0} \r\n ", myMeasRcvr.FMRMS);

            textBox1.Text += "All done!\r\n";
      
            SA44B_Device.SHAPI_CyclePowerOnExit();
 
        }
    }
}
